---
generated_at: 2026-01-20 16:20:00
metrics:
  claims_total: 40
  claims_with_evidence: 39
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート：15-Number Formatting

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：39 / 40、根拠なし：1
- 優先レビュー（高）
  1. **地域設定依存の動作**：Currency/Number書式は実行環境の地域設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Examples/NumberFormatting/Format Integer/Form1.frm`（行1-669）
- E-02: `Examples/NumberFormatting/Format Integer/NumberFormatting.vbp`（行1-31）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行16）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行113）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名はSome Formatted Numbers | E-01 行4, E-03 | ○ |
| C-02 | 数値フォーマット機能をデモンストレーション | E-03, E-04 | ○ |
| C-03 | CorString.Formatを使用 | E-01 行515-630, E-04 | ○ |
| C-04 | mNumber変数はVariant型 | E-01 行509 | ○ |
| C-05 | Option1は64-Integer選択 | E-01 行106-122, 655 | ○ |
| C-06 | Option2はFloat選択 | E-01 行89-105, 657 | ○ |
| C-07 | txtInput_ChangeでUpdate呼び出し | E-01 行649-651 | ○ |
| C-08 | Option1_ClickでUpdate呼び出し | E-01 行641-643 | ○ |
| C-09 | Option2_ClickでUpdate呼び出し | E-01 行645-647 | ○ |
| C-10 | Update関数で数値変換とフォーマット更新 | E-01 行653-668 | ○ |
| C-11 | CInt64で64ビット整数変換 | E-01 行656 | ○ |
| C-12 | CDblで浮動小数点変換 | E-01 行658 | ○ |
| C-13 | UpdateGeneral関数でG書式 | E-01 行511-531 | ○ |
| C-14 | {0:G}で全桁表示 | E-01 行515 | ○ |
| C-15 | {0:G10}で最大10桁 | E-01 行520 | ○ |
| C-16 | {0:G3}で有効数字3桁 | E-01 行525 | ○ |
| C-17 | {0:g3}で小文字e | E-01 行530 | ○ |
| C-18 | UpdateDecimal関数でD書式 | E-01 行533-548 | ○ |
| C-19 | D書式はFloat時N/A | E-01 行545-546 | ○ |
| C-20 | {0:D}で整数表示 | E-01 行537 | ○ |
| C-21 | {0:D10}で10桁ゼロ埋め | E-01 行543 | ○ |
| C-22 | UpdateScientific関数でE書式 | E-01 行550-563 | ○ |
| C-23 | {0:E}で大文字指数表記 | E-01 行554 | ○ |
| C-24 | {0:e}で小文字指数表記 | E-01 行558 | ○ |
| C-25 | {0:E4}で小数点以下4桁 | E-01 行562 | ○ |
| C-26 | UpdateFixed関数でF書式 | E-01 行565-580 | ○ |
| C-27 | {0:F}でデフォルト2桁 | E-01 行570 | ○ |
| C-28 | {0:F4}で小数点以下4桁 | E-01 行574 | ○ |
| C-29 | {0:F0}で小数点なし | E-01 行579 | ○ |
| C-30 | UpdateCurrency関数でC書式 | E-01 行582-592 | ○ |
| C-31 | {0:C}で通貨形式 | E-01 行586 | ○ |
| C-32 | {0:C3}で小数点以下3桁 | E-01 行591 | ○ |
| C-33 | UpdateNumber関数でN書式 | E-01 行594-610 | ○ |
| C-34 | {0:N}でグループ区切り | E-01 行600 | ○ |
| C-35 | {0:N0}で小数なし | E-01 行604 | ○ |
| C-36 | {0:N4}で小数点以下4桁 | E-01 行609 | ○ |
| C-37 | UpdateHex関数でX書式 | E-01 行612-639 | ○ |
| C-38 | X書式はFloat時N/A | E-01 行634-637 | ○ |
| C-39 | VBCorLib 3.0への参照が必要 | E-02 行3 | ○ |
| C-40 | Currency/Number書式の地域設定依存 | E-01 行583-585, 595-598（コメント） | △ |

## 4) 不足情報（Unknown / Missing）
- C-40: 地域設定依存の実際の動作
  - 候補：Windows地域設定を変更しての実機テスト / .NET Framework仕様書

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ソースコードから直接確認可能な内容が大半
- Currency/Number書式は地域設定（Windowsのコントロールパネル）に依存するため、環境によって出力が異なる可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] Form1.frmの行番号が実際のソースと一致するか確認
- [ ] 各書式指定子のCorString.Format呼び出しが正確に記述されているか確認
- [ ] 画面機能マッピングとの整合性確認
- [ ] 実際の画面でフォーマット結果が正しく表示されるか確認
